package com.biz.crm.dms.promotion;

import com.biz.crm.common.PageResult;
import com.biz.crm.dms.promotion.impl.PromotionPolicyTemplateFeignImpl;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 促销模板
 *  @author: luoqi
 *  @Date: 2020-10-19 18:16
 *  @version: V1.0
 *  @Description:
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "promotionPolicyTemplateFeign",name="crm-dms",path = "dms",fallbackFactory = PromotionPolicyTemplateFeignImpl.class)
public interface PromotionPolicyTemplateFeign {


    /**
     * 新增、更新
     *  @author: luoqi
     *  @Date: 2020-10-19 18:19
     *  @version: V1.0
     *  @Description:
     */
    @PostMapping(value = "/promotion/template")
    Result addOrUpdate(@RequestBody PromotionPolicyTemplateEditVo vo);


    /**
     * 加载模板编辑页面数据
     *  @author: luoqi
     *  @Date: 2020-10-19 18:43
     *  @version: V1.0
     *  @Description:
     */
    @GetMapping("/promotion/template/editinfo")
    Result<PromotionPolicyTemplateEditVo> loadTemplateEditVo(@RequestParam("templateId") String templateId, @RequestParam("promotionType") String promotionType) ;


    /**
     * 加载模板信息-政策编辑场景
     *  @author: luoqi
     *  @Date: 2020-10-19 18:43
     *  @version: V1.0
     *  @Description:
     */
    @GetMapping("/promotion/template/loadtemplateinfo")
    Result<PromotionPolicyTemplateEditVo> loadTemplateInfo(@RequestParam("templateId") String templateId) ;

    @PostMapping(value = "/promotion/template/page")
    Result<PageResult<PromotionPolicyTemplateVo>> getPageList(@RequestBody PromotionPolicyTemplateQueryVo vo) ;

    @DeleteMapping("/promotion/template")
    Result del(@RequestBody List<String> templateIds);

    @PostMapping(value = "/promotion/template/disable")
    Result disable(@RequestBody List<String> templateIds) ;

    @PostMapping(value = "/promotion/template/enable")
    Result enable(@RequestBody List<String> templateIds) ;

}
