package com.biz.crm.dms.promotion.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.dms.promotion.PromotionPolicyProductFeign;
import com.biz.crm.nebular.dms.promotion.*;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 促销政策商品
 * @author xi.peng
 */
@Slf4j
@Component
public class PromotionPolicyProductFeignImpl extends BaseAbstract implements FallbackFactory<PromotionPolicyProductFeign> {
    @Override
    public PromotionPolicyProductFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new PromotionPolicyProductFeign() {

            @Override
            public Result<List<PromotionPolicyProductRespVo>> selectListByPromotionPolicyCodes(PromotionPolicyCodesVo reqVo) {
                return doBack();
            }
        };
    }
}
