package com.biz.crm.dms.rotationpic;

import com.biz.crm.common.PageResult;
import com.biz.crm.dms.rotationpic.impl.RotationPicFeignImpl;
import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.ArrayList;

/** 轮播图
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/8/26 15:39
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "rotationPicFeign",name="crm-dms",path = "dms",fallbackFactory = RotationPicFeignImpl.class)
public interface RotationPicFeign {

    /**
     * 新增
     */
    @PostMapping(value = "/m/rotationpic/add")
    Result add(@RequestBody DmsRotationPicVo dmsRotationPicVo);

    /**
     * 编辑
     * @param dmsRotationPicVo
     * @return
     */
    @PostMapping(value = "/m/rotationpic/edit")
    Result edit(@RequestBody DmsRotationPicVo dmsRotationPicVo);


    /**
     * 通过id查询
     * @param id
     * @return
     */
    @PostMapping(value = "/m/rotationpic/findById")
    Result<DmsRotationPicVo> findById(@RequestParam("id") String id);


    /**
     * 分页搜索客户组织
     * @param dmsRotationPicVo
     * @return
     */
    @PostMapping(value = "/m/rotationpic/list")
    Result<PageResult<DmsRotationPicVo>> list(@RequestBody DmsRotationPicVo dmsRotationPicVo);


    /**
     * 根据id批量删除
     * @param ids
     * @return
     */
    @PostMapping(value = "/m/rotationpic/delByIds")
    Result<Object> delByIds(@RequestBody ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     * @param dmsRotationPicVo
     * @return
     */
    @PostMapping(value = "/m/rotationpic/delByParam")
    Result<Object> delByParam(@RequestBody DmsRotationPicVo dmsRotationPicVo);
}
