package com.biz.crm.external;

import com.biz.crm.common.OpenIdVo;
import com.biz.crm.external.impl.WeChatFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zxw
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "weChatFeign", name = "crm-external", path = "external", fallbackFactory = WeChatFeignImpl.class)
public interface WeChatFeign {

    @GetMapping("/weChatController/obtainOpenId")
    Result<OpenIdVo> obtainOpenId(@RequestParam(value = "code") String code);

    @GetMapping("/weChatController/generateTest")
    Result<Integer> generateTest();
}
