package com.biz.crm.job;

import com.biz.crm.common.PageResult;
import com.biz.crm.job.impl.QrtzScheduleJobFeignImpl;
import com.biz.crm.nebular.job.req.QrtzScheduleJobReqVo;
import com.biz.crm.nebular.job.resp.QrtzScheduleJobRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Project crm-core-prd
 * @PackageName com.biz.crm.job
 * @ClassName QrtzScheduleJobFeign
 * @Author X.S
 * @Date 2020/9/30 5:03 PM
 * @Description
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "QrtzScheduleJobFeign",name="crm-job",path = "job",fallbackFactory = QrtzScheduleJobFeignImpl.class)
public interface QrtzScheduleJobFeign {
    /**
     * 列表
     */
    @PostMapping("/qrtzScheduleJob/list")
    Result<PageResult<QrtzScheduleJobRespVo>> list(@RequestBody QrtzScheduleJobReqVo sfaVisitPlanReqVo);

    /**
     * 查询
     */
    @PostMapping("/qrtzScheduleJob/query")
    Result<QrtzScheduleJobRespVo> query(@RequestBody QrtzScheduleJobReqVo sfaVisitPlanReqVo);

    /**
     * 新增
     */
    @PostMapping("/qrtzScheduleJob/save")
    Result save(@RequestBody QrtzScheduleJobReqVo sfaVisitPlanReqVo);

    /**
     * 更新
     */
    @PostMapping("/qrtzScheduleJob/update")
    Result update(@RequestBody QrtzScheduleJobReqVo sfaVisitPlanReqVo);

    /**
     * 启用
     */
    @PostMapping("/qrtzScheduleJob/enable")
    Result enable(@RequestBody QrtzScheduleJobReqVo sfaVisitPlanReqVo);

    /**
     * 停用
     */
    @PostMapping("/qrtzScheduleJob/disable")
    Result disable(@RequestBody QrtzScheduleJobReqVo sfaVisitPlanReqVo);

    /**
     * 删除
     */
    @PostMapping("/qrtzScheduleJob/delete")
    Result delete(@RequestBody QrtzScheduleJobReqVo sfaVisitPlanReqVo);

    /**
     * 运行一次
     */
    @PostMapping("/qrtzScheduleJob/runOnce")
    Result runOnce(@RequestBody QrtzScheduleJobReqVo sfaVisitPlanReqVo);

}
