package com.biz.crm.mdm.bpmrole;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.bpmrole.impl.MdmBpmRoleFeignImpl;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 流程角色表feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmBpmRoleFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmBpmRoleFeignImpl.class)
public interface MdmBpmRoleFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmBpmRoleController/pageList")
    Result<PageResult<MdmBpmRoleRespVo>> pageList(@RequestBody MdmBpmRoleReqVo reqVo);

    /**
     * 查询
     */
    @GetMapping("/mdmBpmRoleController/detail")
    Result<MdmBpmRoleRespVo> detail(@RequestParam("id") String id, @RequestParam("bpmRoleCode") String bpmRoleCode);

    /**
     * 新增
     */
    @PostMapping("/mdmBpmRoleController/save")
    Result save(@RequestBody MdmBpmRoleReqVo reqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmBpmRoleController/update")
    Result update(@RequestBody MdmBpmRoleReqVo reqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmBpmRoleController/delete")
    Result delete(@RequestBody List<String> ids);

    /**
     * 启用
     */
    @PostMapping("/mdmBpmRoleController/enable")
    Result enable(@RequestBody List<String> ids);

    /**
     * 禁用
     */
    @PostMapping("/mdmBpmRoleController/disable")
    Result disable(@RequestBody List<String> ids);

    /**
     * 根据职位编码集合查询关联的流程角色编码集合
     *
     * @param positionCodeList
     * @return
     */
    @PostMapping("/mdmBpmRoleController/findBpmRoleCodeSetByPositionCodeList")
    Result<Set<String>> findBpmRoleCodeSetByPositionCodeList(@RequestBody List<String> positionCodeList);
}
