package com.biz.crm.mdm.button.impl;

import com.biz.crm.mdm.button.MdmButtonFeign;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import java.util.ArrayList;

/**
 * 按扭feign接口熔断类
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */
@Slf4j
@Component
public class MdmButtonFeignImpl extends BaseAbstract implements FallbackFactory<MdmButtonFeign> {

    @Override
    public MdmButtonFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmButtonFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmButtonRespVo>> list(MdmButtonReqVo mdmButtonReqVo) {
                doBack();
                PageResult<MdmButtonRespVo> build = PageResult.<MdmButtonRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmButtonRespVo> query(MdmButtonReqVo mdmButtonReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmButtonReqVo mdmButtonReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmButtonReqVo mdmButtonReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmButtonReqVo mdmButtonReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmButtonReqVo mdmButtonReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmButtonReqVo mdmButtonReqVo) {
                return doBack();
            }
        };
    }
}
