package com.biz.crm.mdm.buttonrole;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.buttonrole.impl.MdmButtonRoleFeignImpl;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleReqVo;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 按钮-角色关联feign接口
 *
 * @author zxw
 * @date 2020-11-18 11:51:48
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "MdmButtonRoleFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmButtonRoleFeignImpl.class)
public interface MdmButtonRoleFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmbuttonrole/list")
    Result<PageResult<MdmButtonRoleRespVo>> list(@RequestBody MdmButtonRoleReqVo mdmButtonRoleReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmbuttonrole/query")
    Result<MdmButtonRoleRespVo> query(@RequestBody MdmButtonRoleReqVo mdmButtonRoleReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmbuttonrole/save")
    Result save(@RequestBody MdmButtonRoleReqVo mdmButtonRoleReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmbuttonrole/update")
    Result update(@RequestBody MdmButtonRoleReqVo mdmButtonRoleReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmbuttonrole/delete")
    Result delete(@RequestBody MdmButtonRoleReqVo mdmButtonRoleReqVo);

}
