package com.biz.crm.mdm.buttonrole.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.buttonrole.MdmButtonRoleFeign;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleReqVo;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 按钮-角色关联feign接口熔断类
 *
 * @author zxw
 * @date 2020-11-18 11:51:48
 */
@Slf4j
@Component
public class MdmButtonRoleFeignImpl extends BaseAbstract implements FallbackFactory<MdmButtonRoleFeign> {

    @Override
    public MdmButtonRoleFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmButtonRoleFeign() {
            /**
             * 列表
             */
            @Override
            public Result<PageResult<MdmButtonRoleRespVo>> list(MdmButtonRoleReqVo mdmButtonRoleReqVo) {
                doBack();
                PageResult<MdmButtonRoleRespVo> build = PageResult.<MdmButtonRoleRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmButtonRoleRespVo> query(MdmButtonRoleReqVo mdmButtonRoleReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmButtonRoleReqVo mdmButtonRoleReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmButtonRoleReqVo mdmButtonRoleReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmButtonRoleReqVo mdmButtonRoleReqVo) {
                return doBack();
            }

        };
    }
}
