package com.biz.crm.mdm.customer.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.customer.MdmCustomerCallBackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class MdmCustomerCallBackFeignImpl extends BaseAbstract implements FallbackFactory<MdmCustomerCallBackFeign> {

    @Override
    public MdmCustomerCallBackFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmCustomerCallBackFeign() {
            @Override
            public Result callback(ActivitiCallBackVo activitiCallBackVo) {
                return doBack();
            }
        };
    }
}
