package com.biz.crm.mdm.customermaterial;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.mdm.customermaterial.impl.MdmCustomerMaterialFeignImpl;

/**
 * 客户物料feign接口
 *
 * @author huang.long
 * @date 2020-09-03 10:26:02
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmCustomerMaterialFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmCustomerMaterialFeignImpl.class)
public interface MdmCustomerMaterialFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmcustomermaterial/list")
    Result<PageResult<MdmCustomerMaterialRespVo>> list(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmcustomermaterial/query")
    Result<MdmCustomerMaterialRespVo> query(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmcustomermaterial/save")
    Result save(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmcustomermaterial/update")
    Result update(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmcustomermaterial/delete")
    Result delete(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmcustomermaterial/enable")
    Result enable(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmcustomermaterial/disable")
    Result disable(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);
}
