package com.biz.crm.mdm.functionrole.impl;

import com.biz.crm.mdm.functionrole.MdmFunctionRoleFeign;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleReqVo;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleRespVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import java.util.ArrayList;

/**
 * 职位级别-角色关联表feign接口熔断类
 *
 * @author zxw
 * @date 2020-11-18 10:42:36
 */
@Slf4j
@Component
public class MdmFunctionRoleFeignImpl extends BaseAbstract implements FallbackFactory<MdmFunctionRoleFeign> {

    @Override
    public MdmFunctionRoleFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmFunctionRoleFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmFunctionRoleRespVo>> list(MdmFunctionRoleReqVo mdmFunctionRoleReqVo) {
                doBack();
                PageResult<MdmFunctionRoleRespVo> build = PageResult.<MdmFunctionRoleRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmFunctionRoleRespVo> query(MdmFunctionRoleReqVo mdmFunctionRoleReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmFunctionRoleReqVo mdmFunctionRoleReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmFunctionRoleReqVo mdmFunctionRoleReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmFunctionRoleReqVo mdmFunctionRoleReqVo) {
                return doBack();
            }

        };
    }
}
