package com.biz.crm.mdm.kms;

import com.biz.crm.mdm.kms.impl.MdmKmsFeignImpl;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 终端信息feign接口
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmKmsFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmKmsFeignImpl.class)
public interface MdmKmsFeign {

    @ApiOperation("kms产品层级批量新增")
    @PostMapping("/mdmCategoryController/addBatch")
    Result<Object> addCategoryBatch(@RequestBody List<MdmProductLevelReqVo> list);

    @ApiOperation("kms商品批量新增")
    @PostMapping("/mdmProController/addBatch")
    Result<Object> addProBatch(@RequestBody List<MdmProductReqVo> list);

    @ApiOperation("kms门店批量新增")
    @PostMapping("/mdmStoreController/addBatch")
    Result<Object> addStoreBatch(@RequestBody List<MdmTerminalVo> list);

}
