package com.biz.crm.mdm.map;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.map.impl.MdmTerminalCustomerElasticsearchFeignImpl;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 客户和终端Elasticsearch feign接口
 *
 * @author yangshan
 * @date 2021-3-10 15:20:25
 */

@FeignClient(url = "${feign.urlip:}", qualifier = "MdmTerminalCustomerElasticsearchFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmTerminalCustomerElasticsearchFeignImpl.class)
public interface MdmTerminalCustomerElasticsearchFeign {

    /**
     * 列表
     * @param pageReqVo
     * @return
     */
    @PostMapping("/MdmTerminalCustomerElasticsearchController/list")
    Result<PageResult<MdmTerminalCustomerElasticsearchRespVo>> list(@RequestBody MdmTerminalCustomerElasticsearchPageReqVo pageReqVo);
}
