package com.biz.crm.mdm.org;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.mdm.org.impl.MdmOrgFeignImpl;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.org.req.BaseOrgTreeReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 组织表feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmOrgFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmOrgFeignImpl.class)
public interface MdmOrgFeign {

    /**
     * 根据id或者组织编码获取组织主表信息
     *
     * @param id
     * @param orgCode
     * @return
     */
    @GetMapping("/mdmOrgController/detail")
    Result<MdmOrgRespVo> detail(@RequestParam("id") String id, @RequestParam("orgCode") String orgCode);

    /**
     * 根据id集合批量查询组织主表信息
     *
     * @param ids
     * @return
     */
    @PostMapping("/mdmOrgController/detailBatchByIds")
    Result<List<MdmOrgRespVo>> detailBatchByIds(@RequestBody List<String> ids);

    /**
     * 根据组织编码集合批量查询组织主表信息
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmOrgController/detailBatchByOrgCodeList")
    Result<List<MdmOrgRespVo>> detailBatchByOrgCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 查询条件下的组织，返回（pageSize）对应条数
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/mdmOrgController/findOrgAndChildrenList")
    Result<List<MdmOrgRespVo>> findOrgAndChildrenList(@RequestBody MdmOrgSearchReqVo reqVo);

    /**
     * 根据组织id或者编码查询全部下级（含当前）组织列表
     */
    @PostMapping("/mdmOrgController/findAllChildrenOrgList")
    Result<List<MdmOrgRespVo>> findAllChildrenOrgList(@RequestBody MdmOrgReqVo mdmOrgReqVo);


    @GetMapping("/mdmOrgController/detail")
    Result<MdmOrgRespVo> detail(@RequestParam(value = "orgCode", required = false) String orgCode);

    /**
     * 根据组织id或者编码查询当前组织的直接下级（不含当前）组织列表
     */
    @PostMapping("/mdmOrgController/findSingleChildrenOrgList")
    Result<List<MdmOrgRespVo>> findSingleChildrenOrgList(@RequestBody MdmOrgReqVo mdmOrgReqVo);

    /**
     * 根据组织id或者编码查询全部上级（含当前）组织列表
     */
    @PostMapping("/mdmOrgController/findAllParentOrgList")
    Result<List<MdmOrgRespVo>> findAllParentOrgList(@RequestBody MdmOrgReqVo mdmOrgReqVo);

    /**
     * 根据组织id或者编码查询当前组织的直接上级组织
     */
    @PostMapping("/mdmOrgController/findSingleParentOrg")
    Result<MdmOrgRespVo> findSingleParentOrg(@RequestBody MdmOrgReqVo mdmOrgReqVo);

    /**
     * 根据组织id或者编码查询当前组织的直接上级组织
     */
    @GetMapping("/mdmOrgController/getParentOrg")
    Result<MdmOrgRespVo> getParentOrg(@RequestParam("id") String id, @RequestParam("orgCode") String orgCode);

    /**
     * 重置组织树降维编码
     */
    @PostMapping("/mdmOrgController/resetRuleCode")
    Result resetRuleCode();

    /**
     * 查询这些组织编码对应的组织，每个组织上附带这个组织（含下级组织）下的全部启用的职位
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmOrgController/findOrgWithAllPositionList")
    Result<List<MdmOrgWithPositionRespVo>> findOrgWithAllPositionList(@RequestBody List<String> orgCodeList);

    /**
     * 查询这些组织编码对应的组织，每个组织上附带这个组织（不含下级组织）下的全部启用职位
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmOrgController/findOrgWithSinglePositionList")
    Result<List<MdmOrgWithPositionRespVo>> findOrgWithSinglePositionList(@RequestBody List<String> orgCodeList);


    /**
     * 根据组织编码集合查询当前组织集合
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/mdmOrgController/listCondition")
    Result<List<MdmOrgRespVo>> listCondition(@RequestBody MdmOrgReqVo reqVo);

    /**
     * 查询所有组织（不分页，数据量大，给后台用）(启用状态、组织类型、上级编码精确查询，组织编码、名称模糊查询)
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/mdmOrgController/findOrgList")
    Result<List<MdmOrgRespVo>> findOrgList(@RequestBody MdmOrgReqVo reqVo);

    /**
     * 查询所有组织树形结构（给后台使用），无筛选条件，全部返回（包含停用）
     *
     * @return
     */
    @GetMapping("/mdmOrgController/getOrgTree")
    Result<List<MdmOrgTreeRespVo>> getOrgTree();

    /**
     * 根据组织编码集合查询这些组织（不含自己）的上级组织编码，如果参数本身有上下级关系，则会返回处于上级的组织编码
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmOrgController/findAllParentOrgCodeExcludeSelf")
    Result<List<String>> findAllParentOrgCodeExcludeSelf(@RequestBody List<String> orgCodeList);


    @ApiOperation("组织搜索树")
    @PostMapping("/mdmOrgController/orgSearchTree")
    Result<List<MdmOrgTreeRespVo>> orgSearchTree(@RequestBody MdmOrgReqVo mdmOrgReqVo);

    @ApiOperation("非懒加载组织树")
    @PostMapping("/baseTreeController/orgTree")
    Result<List<BaseTreeRespVo>> orgTree(@RequestBody BaseOrgTreeReqVo reqVo);

    /**
     * 查询分页列表
     * @param mdmOrgReqVo
     * @return
     */
    @PostMapping("/mdmOrgController/pageList")
    Result<PageResult<MdmOrgRespVo>> pageList(@RequestBody MdmOrgReqVo mdmOrgReqVo);

    /**
     * 查询分页列表
     * @param mdmOrgReqVo
     * @return
     */
    @PostMapping("/mdmOrgController/findAllPage")
    Result<PageResult<MdmOrgRespVo>> findAllPage(@RequestBody MdmOrgReqVo mdmOrgReqVo);

    /**
     * 查询全部组织
     * @return
     */
    @GetMapping("/mdmOrgController/getAll")
    Result<List<MdmOrgRespVo>> getAll();

}
