package com.biz.crm.mdm.poi.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.poi.MdmAmapPoiFeign;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiDistanceReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiDistanceRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class MdmAmapPoiFeignImpl extends BaseAbstract implements FallbackFactory<MdmAmapPoiFeign> {

    @Override
    public MdmAmapPoiFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmAmapPoiFeign() {

            @Override
            public Result queryAndUpdate() {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmAmapPoiDistanceRespVo>> findAmapPoiDistancePageList(MdmAmapPoiDistanceReqVo reqVo) {
                return doBack();
            }

        };
    }
}