package com.biz.crm.mdm.positioncustomerorg.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.positioncustomerorg.MdmPositionCustomerOrgFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgUpdateReqVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 职位与用户关联表feign接口熔断类
 *
 * @author zxw
 * @date 2020-11-03 17:31:28
 */
@Slf4j
@Component
public class MdmPositionCustomerOrgFeignImpl extends BaseAbstract implements FallbackFactory<MdmPositionCustomerOrgFeign> {

    @Override
    public MdmPositionCustomerOrgFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmPositionCustomerOrgFeign() {
            @Override
            public Result<PageResult<MdmPositionCustomerOrgRespVo>> unRelationPage(MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmPositionCustomerOrgRespVo>> relationList(MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo) {
                return doBack();
            }

            @Override
            public Result<Object> add(MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo) {
                return doBack();
            }

            @Override
            public Result<Object> remove(MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo) {
                return doBack();
            }
        };
    }
}
