package com.biz.crm.mdm.priceconditiongroup.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.mdm.priceconditiongroup.MdmPriceConditionGroupFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * 条件字段分类主表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Slf4j
@Component
public class MdmPriceConditionGroupFeignImpl extends BaseAbstract implements FallbackFactory<MdmPriceConditionGroupFeign> {

    @Override
    public MdmPriceConditionGroupFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmPriceConditionGroupFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmPriceConditionGroupRespVo>> list(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
                doBack();
                PageResult<MdmPriceConditionGroupRespVo> build = PageResult.<MdmPriceConditionGroupRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmPriceConditionGroupRespVo> query(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
                return doBack();
            }

            /**
             * 查询集合
             */
            @Override
            public Result<List<MdmPriceConditionGroupRespVo>> findConllection(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
                return doBack();
            }
        };
    }
}
