package com.biz.crm.mdm.product;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.product.impl.MdmProductFeignImpl;
import com.biz.crm.nebular.mdm.product.req.MdmProductBySfaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductQueryReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.*;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 商品主表feign接口
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmProductFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmProductFeignImpl.class)
public interface MdmProductFeign {

    /**
     * 通过id或者商品编码查询商品详情
     */
    @GetMapping("/mdmProductController/detail")
    Result<MdmProductRespVo> detail(@RequestParam("id") String id, @RequestParam("productCode") String productCode);

    /**
     * 通过商品id集合批量查询商品主表信息
     */
    @PostMapping("/mdmProductController/queryBatchByIds")
    Result<List<MdmProductRespVo>> queryBatchByIds(@RequestBody List<String> ids);

    /**
     * 通过商品编码集合批量查询商品主表信息
     */
    @PostMapping("/mdmProductController/queryBatchByProductCodeList")
    Result<List<MdmProductRespVo>> queryBatchByProductCodeList(@RequestBody List<String> productCodeList);

    /**
     * 通过产品层级编码集合批量查询商品主表信息（产品层级及下级的全部下级层级关联的商品）
     */
    @PostMapping("/mdmProductController/queryBatchByProductLevelCodeList")
    Result<List<MdmProductRespVo>> queryBatchByProductLevelCodeList(@RequestBody List<String> productLevelCodeList);

    /**
     * 根据条件查询商品
     */
    @PostMapping("/mdmProductController/queryProductList")
    Result<List<MdmProductQueryRespVo>> queryProductList(@RequestBody MdmProductQueryReqVo reqVo);

    /**
     * 根据商品查询图片
     */
    @PostMapping("/mdmProductController/queryBatchProductPictureList")
    Result<List<MdmProductMediaRespVo>> queryBatchProductPictureList(@RequestBody List<String> productCodeList);

    /**
     * 删除
     */
    @PostMapping("/mdmProductController/delete")
    Result delete(@RequestBody List<String> ids);

    /**
     * 启用
     */
    @PostMapping("/mdmProductController/enable")
    Result enable(@RequestBody List<String> ids);

    /**
     * 禁用
     */
    @PostMapping("/mdmProductController/disable")
    Result disable(@RequestBody List<String> ids);

    /**
     * 上架
     */
    @PostMapping("/mdmProductController/upshelf")
    Result upShelf(@RequestBody List<String> ids);

    /**
     * 下架
     */
    @PostMapping("/mdmProductController/downshelf")
    Result downShelf(@RequestBody List<String> ids);


    @ApiModelProperty("条件查询列表")
    @PostMapping("/mdmProductController/listCondition")
    Result<List<MdmProductRespVo>> listCondition(@RequestBody MdmProductReqVo mdmProductReqVo);

    /**
     * 待定
     *
     * @param mdmProductAdviseAndPriceReqVo
     * @return
     */
    @PostMapping("/mdmProductController/queryByProductCodeAndCus")
    Result<Map<String, MdmProductAdviseAndPriceRespVo>> queryByProductCodeAndCus(@RequestBody MdmProductAdviseAndPriceReqVo mdmProductAdviseAndPriceReqVo);

    /**
     * 分页查询列表
     *
     * @param mdmProductReqVo
     * @return
     */
    @PostMapping("/mdmProductController/pageList")
    Result<PageResult<MdmProductRespVo>> pageList(@RequestBody MdmProductReqVo mdmProductReqVo);


    @ApiOperation(value = "sfa查询商品专用接口")
    @PostMapping("/mdmProductController/findProductListSourceSfa")
    Result<PageResult<MdmProductBySfaRespVo>> findProductListSourceSfa(@RequestBody MdmProductBySfaReqVo reqVo);

    @ApiOperation(value = "sfa tpm活动查询商品基础信息")
    @PostMapping("/mdmProductController/findProductBaseSourceSfaTpmAct")
    Result<List<MdmProductBaseDataRespVo>> findProductBaseSourceSfaTpmAct(@RequestBody List<String> productCodeList);

}
