package com.biz.crm.mdm.productlevel.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * feign接口熔断类
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@Slf4j
@Component
public class MdmProductLevelFeignImpl extends BaseAbstract implements FallbackFactory<MdmProductLevelFeign> {

    @Override
    public MdmProductLevelFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmProductLevelFeign() {

            @Override
            public Result<MdmProductLevelRespVo> detail(String id, String productLevelCode) {
                return doBack();
            }

            @Override
            public Result<List<String>> getAllChildrenProductLevelCodeList(String productLevelCode) {
                return doBack();
            }

            @Override
            public Result resetRuleCode() {
                return doBack();
            }

            @Override
            public Result<List<MdmProductLevelSelectRespVo>> productLevelSelectList(MdmProductLevelSelectReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductLevelRespVo>> getAllProductLevelList() {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmProductLevelRespVo>> pageList(
                MdmProductLevelReqVo mdmProductLevelReqVo) {
                return doBack();
            }
        };
    }
}
