package com.biz.crm.mdm.tableconfig;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.tableconfig.impl.MdmFunctionSubFeignImpl;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "MdmFunctionSubFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmFunctionSubFeignImpl.class)
public interface MdmFunctionSubFeign {

    /**
     * 列表
     */
    @ApiOperation(value = "查询可配置分页菜单列表")
    @PostMapping("/mdmfunctionsub/page")
    Result<PageResult<MdmFunctionRespVo>> page(@RequestBody MdmFunctionReqVo mdmFunctionReqVo);

    @ApiOperation(value = "查询")
    @PostMapping("/mdmfunctionsub/queryCondition")
    Result<MdmFunctionSubRespVo> query(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo);

    @ApiOperation("根据上级编码查询下级菜单集合")
    @PostMapping("/mdmfunctionsub/sub_list")
    Result<List<MdmFunctionSubRespVo>> findSubList(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo);

    @ApiOperation("根据菜单编码与功能编码查询")
    @PostMapping("/mdmfunctionsub/functionSubSearch")
    Result<MdmFunctionSubRespVo> functionSubSearch(@RequestBody MdmFunctionSubReqVo mdmFunctionSubReqVo);
}
