package com.biz.crm.mdm.terminal;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.mdm.terminal.impl.MdmTerminalFeignImpl;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.*;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.UpdateCoordinateReqVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmOrgRCusVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 终端信息feign接口
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmTerminalFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmTerminalFeignImpl.class)
public interface MdmTerminalFeign {


    @ApiOperation(value = "查询列表")
    @PostMapping("/mdmTerminalController/page")
    @CrmDictMethod
    Result<PageResult<MdmTerminalVo>> page(@RequestBody MdmTerminalVo mdmTerminalReqVo);

    @ApiOperation(value = "查询", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "terminalCode", value = "终端编码", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/mdmTerminalController/query")
    Result<MdmTerminalVo> query(@RequestParam(value = "id", required = false) String id,
                                @RequestParam(value = "terminalCode", required = false) String terminalCode);

    @ApiOperation(value = "新增")
    @PostMapping("/mdmTerminalController/save")
    Result<MdmTerminalVo> save(@RequestBody MdmTerminalVo mdmTerminalVo);


    @ApiOperation(value = "批量新增(只适用于腾讯地图数据同步")
    @PostMapping("/mdmTerminalController/saveTxBatch")
    Result<Object> saveTxBatch(@RequestBody MdmTencentMapData mdmTencentMapData);

    @ApiOperation(value = "新增并提交")
    @PostMapping("/mdmTerminalController/saveAndSubmit")
    Result<Object> saveAndSubmit(@RequestBody MdmTerminalVo mdmTerminalVo);

    @ApiOperation(value = "更新")
    @PostMapping("/mdmTerminalController/update")
    Result<Object> update(@RequestBody MdmTerminalVo mdmTerminalVo);

    @ApiOperation("根据客户编码集合修改经纬度")
    @PostMapping("/mdmTerminalController/updateCoordinate")
    Result<Object> updateCoordinate(@RequestBody List<UpdateCoordinateReqVo> updateCoordinateReqVos);

    @ApiOperation(value = "删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/mdmTerminalController/delete")
    Result<Object> delete(@RequestBody List<String> ids);

    @ApiOperation(value = "启用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/mdmTerminalController/enable")
    Result<Object> enable(@RequestBody List<String> ids);

    @ApiOperation(value = "禁用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/mdmTerminalController/disable")
    Result<Object> disable(@RequestBody List<String> ids);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "orgCodes", value = "组织编码集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "根据组织编码查询终端编码集合", httpMethod = "POST")
    @PostMapping("/mdmTerminalController/findByOrgCodeList")
    Result<List<String>> findByOrgCodeList(@RequestBody List<String> orgCodes);

    @ApiOperation("根据组织编码查询当前及下级终端")
    @PostMapping("/mdmTerminalController/findCurrentAndSubTerminalList")
    Result<List<MdmTerminalVo>> findCurrentAndSubTerminalList(@RequestBody List<String> orgCodes);

    @ApiOperation("条件列表查询")
    @PostMapping("/mdmTerminalController/listCondition")
    Result<List<MdmTerminalVo>> listCondition(@RequestBody MdmTerminalVo vo);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "posId", value = "职位ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "posCode", value = "职位编码", required = false, dataType = "String", paramType = "query")
    })
    @ApiOperation(value = "根据职位id或职位编码查询终端列表", httpMethod = "GET")
    @GetMapping("/mdmTerminalController/findPositionTerminalList")
    Result<List<MdmTerminalVo>> findPositionTerminalList(@RequestParam(value = "posId", required = false) String posId, @RequestParam(value = "posCode", required = false) String posCode);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "posId", value = "职位ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "posCode", value = "职位编码", required = false, dataType = "String", paramType = "query")
    })
    @ApiOperation(value = "根据职位id或职位编码查询当前及所有下级职位对应终端列表", httpMethod = "GET")
    @GetMapping("/mdmTerminalController/findCurrentAndSybPositionTerminalList")
    Result<List<MdmTerminalVo>> findCurrentAndSybPositionTerminalList(@RequestParam(value = "posId", required = false) String posId, @RequestParam(value = "posCode", required = false) String posCode);


    @ApiOperation("批量修改与终端关联的企业组织编码")
    @PostMapping("/mdmTerminalController/batchUpdateTerminalOrg")
    Result batchUpdateTerminalOrg(@RequestBody MdmOrgTerminalReqVo reqVo);

    @ApiOperation("获取指定职位终端及主联系人列表")
    @PostMapping("/mdmTerminalController/userTerminalContactPage")
    Result<PageResult<MdmTerminalContactPageVo>> userTerminalContactPage(@RequestBody MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo);

    @ApiOperation("根据终端编码集合查询终端及主联系人列表")
    @PostMapping("/mdmTerminalController/terminalContactPage")
    Result<PageResult<MdmTerminalContactPageVo>> terminalContactPage(@RequestBody MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo);

    @ApiOperation(value = "sfa-根据终端编码集合查询终端及主联系人列表")
    @PostMapping("/mdmTerminalController/sfaFindTerminalContactPage")
    Result<List<MdmTerminalContactPageVo>> sfaFindTerminalContactPage(@RequestBody List<String> terminalCodes);

    @ApiOperation("查询职位关联的终端数量")
    @GetMapping("/mdmTerminalController/findPositionRelationTerminalCount")
    Result<Long> findPositionRelationTerminalCount(@RequestParam("positionCode") String positionCode);

    @ApiOperation("查询职位关联的二批商数量")
    @GetMapping("/mdmTerminalController/findPositionRelationTerminalCustomerCount")
    Result<Long> findPositionRelationTerminalCustomerCount(@RequestParam("positionCode") String positionCode);

    @ApiOperation("根据营业注册号或终端名称查询详情")
    @GetMapping("/mdmTerminalController/findDetailByRegisterOrName")
    Result<MdmTerminalVo> findDetailByRegisterOrName(@RequestParam(value = "licenseRegisterNumber", required = false) String licenseRegisterNumber,
                                                     @RequestParam(value = "terminalName", required = false) String terminalName);

    @ApiOperation("条件查询终端主联系人及距离分页列表")
    @PostMapping("/mdmTerminalController/distanceContactPage")
    Result<PageResult<MdmTerminalContactPageVo>> distanceContactPage(@RequestBody MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo);

    @ApiOperation("条件查询终端主联系人及距离分页列表（可以查到非审批通过的）")
    @PostMapping("/mdmTerminalController/distanceContactNoBpmFilterPage")
    Result<PageResult<MdmTerminalContactPageVo>> distanceContactNoBpmFilterPage(@RequestBody MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo);

    @ApiOperation("根据客户编码或组织编码查询对应门店")
    @PostMapping("/mdmTerminalController/customerTerminalList")
    Result<List<MdmTerminalVo>> customerTerminalList(@RequestBody MdmCustomerTerminalVo mdmCustomerTerminalVo);

    @PostMapping("/mdmTerminalController/detailBatch")
    Result<List<MdmOrgRespVo>> detailBatch(@RequestBody MdmTerminalVo vo);

    @ApiOperation("条件查询终端及主联系人列表")
    @PostMapping("/mdmTerminalController/findTerminalAndContactList")
    Result<PageResult<MdmTerminalContactPageVo>> findTerminalAndContactList(@RequestBody MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo);

    @ApiOperation("根据终端编码集合查询供货关系")
    @PostMapping("/mdmTerminalController/findCustomerByTerminalCode")
    Result<List<MdmTerminalSupplyVo>> findTerminalSupply(@RequestBody MdmTerminalVo mdmTerminalVo);

    @ApiOperation("校验终端编码有没有被组织编码关联")
    @PostMapping("/mdmTerminalController/checkTerminalCodeRelByOrgCodeList")
    Result<Boolean> checkTerminalCodeRelByOrgCodeList(@RequestBody List<String> orgCodeList, @RequestParam("terminalCode") String terminalCode);

    @ApiOperation("校验终端编码有没有被客户编码关联")
    @PostMapping("/mdmTerminalController/checkTerminalCodeRelByCustomerCodeList")
    Result<Boolean> checkTerminalCodeRelByCustomerCodeList(@RequestBody List<String> customerCodeList, @RequestParam("terminalCode") String terminalCode);

    @ApiOperation(value = "校验终端是否被组织/客户关联-sfa专用")
    @PostMapping("/mdmTerminalController/checkTerminalCodeRelByOrgOrCusCode")
    Result<List<String>> checkTerminalCodeRelByOrgOrCusCode(@RequestBody SfaTpmOrgRCusVo orgRCusVo);

    @ApiOperation(value = "根据客户组织编码集合查询客户组织下的终端")
    @PostMapping("/mdmTerminalController/findTerminalByCustomerOrgCodeList")
    Result<List<MdmTerminalVo>> findTerminalByCustomerOrgCodeList(@RequestBody List<String> customerOrgCodeList);

    @ApiOperation("根据名称和地址查询终端详情")
    @GetMapping("/mdmTerminalController/findTerminalByNameOrAddress")
    Result<MdmTerminalVo> findTerminalByNameOrAddress(@RequestParam("terminalName") String terminalName, @RequestParam("terminalAddress") String terminalAddress);

    @ApiOperation(value = "根据终端编码集合查询终端信息以及附属信息")
    @PostMapping("/mdmTerminalController/queryTerminalAndAttachByCode")
    Result<List<MdmTerminalVo>> queryTerminalAndAttachByCode(@RequestBody List<String> terminalCodeList);

    @ApiOperation(value = "通过手机号查询终端详细信息")
    @PostMapping("/mdmTerminalAppletLoginController/getTerminalByPhone")
    Result<List<MdmTerminalVo>> getTerminalByPhone(@RequestParam(value = "phoneCode") String phoneCode);

    @ApiOperation(value = "根据组织编码集合和条件获得终端信息")
    @PostMapping("/mdmTerminalController/queryTerminalByOrgCodeList")
    Result<List<MdmTerminalVo>> queryTerminalByOrgCodeList(@RequestBody SfaTPMTerminalReqVo reqVo);
}
