package com.biz.crm.rebate;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 促销政策
 *  @author: luoqi
 *  @Date: 2020-10-19 18:16
 *  @version: V1.0
 *  @Description:
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "RebateFeign",name="crm-rebate",path = "rebate",fallbackFactory = RebateFeignImpl.class)
public interface RebateFeign {


    /**
     * 通过参数查询返利政策集合(目前需要支持通过返利政策编码集合promotionCodes和是否是查询有效的政策的标识queryEffectiveFlag)
     * @param reqVo
     * @return
     */
    @PostMapping("/api/rebate/findRebatesByParam")
    Result<PageResult<RebateVo>> findRebatesByParam(@RequestBody RebateVo reqVo);

}
