package com.biz.crm.sfa.acttask;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.acttask.req.SfaActRangeReqVo;
import com.biz.crm.nebular.sfa.acttask.resp.SfaActRangeRespVo;
import com.biz.crm.sfa.acttask.impl.SfaActRangeFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 活动范围 feign接口
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaActRangeFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaActRangeFeignImpl.class)
public interface SfaActRangeFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaactrange/list")
    Result<PageResult<SfaActRangeRespVo>> list(@RequestBody SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaactrange/query")
    Result<SfaActRangeRespVo> query(@RequestBody SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaactrange/save")
    Result save(@RequestBody SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaactrange/update")
    Result update(@RequestBody SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaactrange/delete")
    Result delete(@RequestBody SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaactrange/enable")
    Result enable(@RequestBody SfaActRangeReqVo sfaActRangeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaactrange/disable")
    Result disable(@RequestBody SfaActRangeReqVo sfaActRangeReqVo);
}
