package com.biz.crm.sfa.assistant;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.sfa.assistant.impl.SfaWorkTaskReceveFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 工作任务(接收) feign接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkTaskReceveFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkTaskReceveFeignImpl.class)
public interface SfaWorkTaskReceveFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworktaskreceve/list")
    Result<PageResult<SfaWorkTaskReceveRespVo>> list(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworktaskreceve/query")
    Result<SfaWorkTaskReceveRespVo> query(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworktaskreceve/save")
    Result save(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworktaskreceve/update")
    Result update(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworktaskreceve/delete")
    Result delete(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworktaskreceve/enable")
    Result enable(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworktaskreceve/disable")
    Result disable(@RequestBody SfaWorkTaskReceveReqVo sfaWorkTaskReceveReqVo);
}
