package com.biz.crm.sfa.audit;

import com.biz.crm.sfa.audit.impl.SfaAuditProductPriceProFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceProRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceProReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;


/**
 * 产品价格稽查-产品表feign接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaAuditProductPriceProFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaAuditProductPriceProFeignImpl.class)
public interface SfaAuditProductPriceProFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaauditproductpricepro/list")
    Result<PageResult<SfaAuditProductPriceProRespVo>> list(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaauditproductpricepro/query")
    Result<SfaAuditProductPriceProRespVo> query(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaauditproductpricepro/save")
    Result save(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaauditproductpricepro/update")
    Result update(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaauditproductpricepro/delete")
    Result delete(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaauditproductpricepro/enable")
    Result enable(@RequestBody SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaauditproductpricepro/disable")
    Result disable(@RequestBody  SfaAuditProductPriceProReqVo sfaAuditProductPriceProReqVo);
}
