package com.biz.crm.sfa.audit;

import com.biz.crm.sfa.audit.impl.SfaAuditTerminalRealFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;


/**
 * 终端真实性稽查表feign接口
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaAuditTerminalRealFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaAuditTerminalRealFeignImpl.class)
public interface SfaAuditTerminalRealFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaauditterminalreal/list")
    Result<PageResult<SfaAuditTerminalRealRespVo>> list(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaauditterminalreal/query")
    Result<SfaAuditTerminalRealRespVo> query(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaauditterminalreal/save")
    Result save(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaauditterminalreal/update")
    Result update(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaauditterminalreal/delete")
    Result delete(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaauditterminalreal/enable")
    Result enable(@RequestBody SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaauditterminalreal/disable")
    Result disable(@RequestBody  SfaAuditTerminalRealReqVo sfaAuditTerminalRealReqVo);
}
