package com.biz.crm.sfa.audit.impl;

import com.biz.crm.sfa.audit.SfaAuditTpmFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTpmReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * TPM稽查表feign接口熔断类
 *
 * @author rwm
 * @date 2022-04-13 17:58:57
 */
@Slf4j
@Component
public class SfaAuditTpmFeignImpl extends BaseAbstract implements FallbackFactory<SfaAuditTpmFeign> {

    @Override
    public SfaAuditTpmFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaAuditTpmFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaAuditTpmRespVo>> list(SfaAuditTpmReqVo sfaAuditTpmReqVo) {
                doBack();
                PageResult<SfaAuditTpmRespVo> build = PageResult.<SfaAuditTpmRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaAuditTpmRespVo> query(SfaAuditTpmReqVo sfaAuditTpmReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaAuditTpmReqVo sfaAuditTpmReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaAuditTpmReqVo sfaAuditTpmReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaAuditTpmReqVo sfaAuditTpmReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaAuditTpmReqVo sfaAuditTpmReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaAuditTpmReqVo sfaAuditTpmReqVo) {
                return doBack();
            }
        };
    }
}
