package com.biz.crm.sfa.calculateSalary.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryDateRespVo;
import com.biz.crm.sfa.calculateSalary.SfaCalculateSalaryDateFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 计算薪资日期feign接口熔断类
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
@Slf4j
@Component
public class SfaCalculateSalaryDateFeignImpl extends BaseAbstract implements FallbackFactory<SfaCalculateSalaryDateFeign> {

    @Override
    public SfaCalculateSalaryDateFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaCalculateSalaryDateFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaCalculateSalaryDateRespVo>> list(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
                doBack();
                PageResult<SfaCalculateSalaryDateRespVo> build = PageResult.<SfaCalculateSalaryDateRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaCalculateSalaryDateRespVo> query(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaCalculateSalaryDateReqVo sfaCalculateSalaryDateReqVo) {
                return doBack();
            }
        };
    }
}
