package com.biz.crm.sfa.collection;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryConfigRespVo;
import com.biz.crm.sfa.collection.impl.SfaDirectoryConfigFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤表单配置 feign接口
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaDirectoryConfigFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaDirectoryConfigFeignImpl.class)
public interface SfaDirectoryConfigFeign {

    /**
     * 列表
     */
    @PostMapping("/sfadirectoryconfig/list")
    Result<PageResult<SfaDirectoryConfigRespVo>> list(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfadirectoryconfig/query")
    Result<SfaDirectoryConfigRespVo> query(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfadirectoryconfig/save")
    Result save(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfadirectoryconfig/update")
    Result update(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfadirectoryconfig/delete")
    Result delete(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfadirectoryconfig/enable")
    Result enable(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfadirectoryconfig/disable")
    Result disable(@RequestBody SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);
}
