package com.biz.crm.sfa.freesignconfig.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignConfigReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignConfigRespVo;
import com.biz.crm.sfa.freesignconfig.SfaFreesignConfigFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 签到组 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@Component
public class SfaFreesignConfigFeignImpl extends BaseAbstract implements FallbackFactory<SfaFreesignConfigFeign> {

    @Override
    public SfaFreesignConfigFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaFreesignConfigFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaFreesignConfigRespVo>> list(SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
                doBack();
                PageResult<SfaFreesignConfigRespVo> build = PageResult.<SfaFreesignConfigRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaFreesignConfigRespVo> query(SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaFreesignConfigReqVo sfaFreesignConfigReqVo) {
                return doBack();
            }
        };
    }
}
