package com.biz.crm.sfa.freesignconfig.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignPersonnelReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignPersonnelRespVo;
import com.biz.crm.sfa.freesignconfig.SfaFreesignPersonnelFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 签到组-打卡人员 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@Component
public class SfaFreesignPersonnelFeignImpl extends BaseAbstract implements FallbackFactory<SfaFreesignPersonnelFeign> {

    @Override
    public SfaFreesignPersonnelFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaFreesignPersonnelFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaFreesignPersonnelRespVo>> list(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
                doBack();
                PageResult<SfaFreesignPersonnelRespVo> build = PageResult.<SfaFreesignPersonnelRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaFreesignPersonnelRespVo> query(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo) {
                return doBack();
            }
        };
    }
}
