package com.biz.crm.sfa.freesignconfig.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignTypeReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignTypeRespVo;
import com.biz.crm.sfa.freesignconfig.SfaFreesignSignTypeFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 签到组--打卡类型 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@Component
public class SfaFreesignSignTypeFeignImpl extends BaseAbstract implements FallbackFactory<SfaFreesignSignTypeFeign> {

    @Override
    public SfaFreesignSignTypeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaFreesignSignTypeFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaFreesignSignTypeRespVo>> list(SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
                doBack();
                PageResult<SfaFreesignSignTypeRespVo> build = PageResult.<SfaFreesignSignTypeRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaFreesignSignTypeRespVo> query(SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
                return doBack();
            }
        };
    }
}
