package com.biz.crm.sfa.moblie;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.moblie.impl.SfaTerminalFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 终端审批流程结束回调
 * @author YuanZiJian
 * @date 2021/1/5 11:24
 * @version: V1.0
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "SfaTerminalFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaTerminalFeignImpl.class)
public interface SfaTerminalFeign extends CallbackFeign {

    /**
     * 终端流程结束
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("/client/terminalEnd")
    Result callback(ActivitiCallBackVo activitiCallBackVo);

}
