package com.biz.crm.sfa.notice;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReceivingReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReceivingRespVo;
import com.biz.crm.sfa.notice.impl.SfaNoticeReceivingFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 公告发布范围 feign接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaNoticeReceivingFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaNoticeReceivingFeignImpl.class)
public interface SfaNoticeReceivingFeign {

    /**
     * 列表
     */
    @PostMapping("/sfanoticereceiving/list")
    Result<PageResult<SfaNoticeReceivingRespVo>> list(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfanoticereceiving/query")
    Result<SfaNoticeReceivingRespVo> query(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfanoticereceiving/save")
    Result save(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfanoticereceiving/update")
    Result update(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfanoticereceiving/delete")
    Result delete(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfanoticereceiving/enable")
    Result enable(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfanoticereceiving/disable")
    Result disable(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);
}
