package com.biz.crm.sfa.notice.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReceivingReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReceivingRespVo;
import com.biz.crm.sfa.notice.SfaNoticeReceivingFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 公告发布范围 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Slf4j
@Component
public class SfaNoticeReceivingFeignImpl extends BaseAbstract implements FallbackFactory<SfaNoticeReceivingFeign> {

    @Override
    public SfaNoticeReceivingFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaNoticeReceivingFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaNoticeReceivingRespVo>> list(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
                doBack();
                PageResult<SfaNoticeReceivingRespVo> build = PageResult.<SfaNoticeReceivingRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaNoticeReceivingRespVo> query(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
                return doBack();
            }
        };
    }
}
