package com.biz.crm.sfa.picture;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.sfa.picture.impl.SfaVisitPictureFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访相关照片信息 feign接口
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitPictureFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitPictureFeignImpl.class)
public interface SfaVisitPictureFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitpicture/list")
    Result<PageResult<SfaVisitPictureRespVo>> list(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitpicture/query")
    Result<SfaVisitPictureRespVo> query(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitpicture/save")
    Result save(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitpicture/update")
    Result update(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitpicture/delete")
    Result delete(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitpicture/enable")
    Result enable(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitpicture/disable")
    Result disable(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo);
}
