package com.biz.crm.sfa.visitdealer;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.sfa.visitdealer.impl.SfaVisitDealerDetailFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 经销商拜访明细;feign接口
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitDealerDetailFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitDealerDetailFeignImpl.class)
public interface SfaVisitDealerDetailFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitdealerdetail/list")
    Result<PageResult<SfaVisitDealerDetailRespVo>> list(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitdealerdetail/query")
    Result<SfaVisitDealerDetailRespVo> query(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitdealerdetail/save")
    Result save(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitdealerdetail/update")
    Result update(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitdealerdetail/delete")
    Result delete(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitdealerdetail/enable")
    Result enable(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitdealerdetail/disable")
    Result disable(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 查询本期对应拜访数
     * @param reqVo
     * @return
     */
    @PostMapping("/sfaVisitDealerDetailController/findVisitNumber")
    Result<MdmCustomerCountRespVo> findVisitNumber(@RequestBody MdmCustomerCountReqVo reqVo);
}
