package com.biz.crm.sfa.visitnote;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitAssitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitAssitPlanRespVo;
import com.biz.crm.sfa.visitnote.impl.SfaVisitAssitPlanFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import java.util.List;

/**
 * 协防计划制定 feign接口
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitAssitPlanFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitAssitPlanFeignImpl.class)
public interface SfaVisitAssitPlanFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitassitplan/list")
    Result<PageResult<SfaVisitAssitPlanRespVo>> list(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitassitplan/query")
    Result<SfaVisitAssitPlanRespVo> query(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitassitplan/save")
    Result save(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitassitplan/update")
    Result update(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitassitplan/delete")
    Result delete(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitassitplan/enable")
    Result enable(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitassitplan/disable")
    Result disable(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 通过id批量查询
     * @param ids
     * @return
     */
    @PostMapping("/sfaHelpDefenseController/queryListById")
    Result<List<SfaHelpDefenseRespVo>> queryListById(@RequestBody List<String> ids);
}
