package com.biz.crm.sfa.visitnote.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitAssitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitAssitPlanRespVo;
import com.biz.crm.sfa.visitnote.SfaVisitAssitPlanFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 协防计划制定 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@Component
public class SfaVisitAssitPlanFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitAssitPlanFeign> {

    @Override
    public SfaVisitAssitPlanFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitAssitPlanFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitAssitPlanRespVo>> list(SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
                doBack();
                PageResult<SfaVisitAssitPlanRespVo> build = PageResult.<SfaVisitAssitPlanRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitAssitPlanRespVo> query(SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            /**
             * 通过id批量查询
             *
             * @param ids
             */
            @Override
            public Result<List<SfaHelpDefenseRespVo>> queryListById(List<String> ids) {
                return doBack();
            }
        };
    }
}
