package com.biz.crm.sfa.visitnote.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.sfa.visitnote.SfaVisitGroupFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 线路组管理 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
@Slf4j
@Component
public class SfaVisitGroupFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitGroupFeign> {

    @Override
    public SfaVisitGroupFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitGroupFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitGroupRespVo>> list(SfaVisitGroupReqVo sfaVisitGroupReqVo) {
                doBack();
                PageResult<SfaVisitGroupRespVo> build = PageResult.<SfaVisitGroupRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitGroupRespVo> query(SfaVisitGroupReqVo sfaVisitGroupReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitGroupReqVo sfaVisitGroupReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitGroupReqVo sfaVisitGroupReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitGroupReqVo sfaVisitGroupReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitGroupReqVo sfaVisitGroupReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitGroupReqVo sfaVisitGroupReqVo) {
                return doBack();
            }
        };
    }
}
