package com.biz.crm.sfa.visitstep;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitStepActivityFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤(活动执行);feign接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepActivityFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepActivityFeignImpl.class)
public interface SfaVisitStepActivityFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitstepactivity/list")
    Result<PageResult<SfaVisitStepActivityRespVo>> list(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitstepactivity/query")
    Result<SfaVisitStepActivityRespVo> query(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitstepactivity/save")
    Result save(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitstepactivity/update")
    Result update(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitstepactivity/delete")
    Result delete(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitstepactivity/enable")
    Result enable(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitstepactivity/disable")
    Result disable(@RequestBody SfaVisitStepActivityReqVo sfaVisitStepActivityReqVo);
}
