package com.biz.crm.sfa.visitstep;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStockReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStockRespVo;
import com.biz.crm.sfa.visitstep.impl.SfaVisitStepStockFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤(库存盘点);feign接口
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepStockFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepStockFeignImpl.class)
public interface SfaVisitStepStockFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitstepstock/list")
    Result<PageResult<SfaVisitStepStockRespVo>> list(@RequestBody SfaVisitStepStockReqVo sfaVisitStepStockReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitstepstock/query")
    Result<SfaVisitStepStockRespVo> query(@RequestBody SfaVisitStepStockReqVo sfaVisitStepStockReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitstepstock/save")
    Result save(@RequestBody SfaVisitStepStockReqVo sfaVisitStepStockReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitstepstock/update")
    Result update(@RequestBody SfaVisitStepStockReqVo sfaVisitStepStockReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitstepstock/delete")
    Result delete(@RequestBody SfaVisitStepStockReqVo sfaVisitStepStockReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitstepstock/enable")
    Result enable(@RequestBody SfaVisitStepStockReqVo sfaVisitStepStockReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitstepstock/disable")
    Result disable(@RequestBody SfaVisitStepStockReqVo sfaVisitStepStockReqVo);
}
