package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderItemReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderItemRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepOrderItemFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访步骤(订单明细);feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Component
public class SfaVisitStepOrderItemFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitStepOrderItemFeign> {

    @Override
    public SfaVisitStepOrderItemFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitStepOrderItemFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitStepOrderItemRespVo>> list(SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo) {
                doBack();
                PageResult<SfaVisitStepOrderItemRespVo> build = PageResult.<SfaVisitStepOrderItemRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitStepOrderItemRespVo> query(SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitStepOrderItemReqVo sfaVisitStepOrderItemReqVo) {
                return doBack();
            }
        };
    }
}
