package com.biz.crm.sfa.worksign;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelUserReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelUserRespVo;
import com.biz.crm.sfa.worksign.impl.SfaTravelUserFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 出差人员表 feign接口
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaTravelUserFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaTravelUserFeignImpl.class)
public interface SfaTravelUserFeign {

    /**
     * 列表
     */
    @PostMapping("/sfatraveluser/list")
    Result<PageResult<SfaTravelUserRespVo>> list(@RequestBody SfaTravelUserReqVo sfaTravelUserReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfatraveluser/query")
    Result<SfaTravelUserRespVo> query(@RequestBody SfaTravelUserReqVo sfaTravelUserReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfatraveluser/save")
    Result save(@RequestBody SfaTravelUserReqVo sfaTravelUserReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfatraveluser/update")
    Result update(@RequestBody SfaTravelUserReqVo sfaTravelUserReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfatraveluser/delete")
    Result delete(@RequestBody SfaTravelUserReqVo sfaTravelUserReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfatraveluser/enable")
    Result enable(@RequestBody SfaTravelUserReqVo sfaTravelUserReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfatraveluser/disable")
    Result disable(@RequestBody SfaTravelUserReqVo sfaTravelUserReqVo);
}
