package com.biz.crm.sfa.worksign;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignLeaveCancelEndFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author ren.gang
 * @ClassName SfaWorkSignLeaveEndFeign.java
 * @Description 销假流程结束
 * @createTime 2020年12月16日 10:14:00
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignLeaveCancelEndFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignLeaveCancelEndFeignImpl.class)
public interface SfaWorkSignLeaveCancelEndFeign extends CallbackFeign {

    /**
     * 流程结束
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("/sfaWorkSignAudit/leaveCancelEnd")
    Result callback(ActivitiCallBackVo activitiCallBackVo);
}