package com.biz.crm.sfa.worksign;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignPictureReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignPictureRespVo;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignPictureFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 考勤照片 feign接口
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignPictureFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignPictureFeignImpl.class)
public interface SfaWorkSignPictureFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksignpicture/list")
    Result<PageResult<SfaWorkSignPictureRespVo>> list(@RequestBody SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksignpicture/query")
    Result<SfaWorkSignPictureRespVo> query(@RequestBody SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksignpicture/save")
    Result save(@RequestBody SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksignpicture/update")
    Result update(@RequestBody SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksignpicture/delete")
    Result delete(@RequestBody SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksignpicture/enable")
    Result enable(@RequestBody SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksignpicture/disable")
    Result disable(@RequestBody SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo);
}
