package com.biz.crm.sfa.worksign;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignRecordFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 考勤打卡记录表 feign接口
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignRecordFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignRecordFeignImpl.class)
public interface SfaWorkSignRecordFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksignrecord/list")
    Result<PageResult<SfaWorkSignRecordRespVo>> list(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksignrecord/query")
    Result<SfaWorkSignRecordRespVo> query(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksignrecord/save")
    Result save(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksignrecord/update")
    Result update(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksignrecord/delete")
    Result delete(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksignrecord/enable")
    Result enable(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksignrecord/disable")
    Result disable(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);
}
