package com.biz.crm.sfa.worksign.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.sfa.worksign.SfaLeaveFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 请假申请 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Slf4j
@Component
public class SfaLeaveFeignImpl extends BaseAbstract implements FallbackFactory<SfaLeaveFeign> {

    @Override
    public SfaLeaveFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaLeaveFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaLeaveRespVo>> list(SfaLeaveReqVo sfaLeaveReqVo) {
                doBack();
                PageResult<SfaLeaveRespVo> build = PageResult.<SfaLeaveRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaLeaveRespVo> query(SfaLeaveReqVo sfaLeaveReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaLeaveReqVo sfaLeaveReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaLeaveReqVo sfaLeaveReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaLeaveReqVo sfaLeaveReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaLeaveReqVo sfaLeaveReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaLeaveReqVo sfaLeaveReqVo) {
                return doBack();
            }
        };
    }
}
