package com.biz.crm.sfa.worksign.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.sfa.worksign.SfaTravelFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 出差申请 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Slf4j
@Component
public class SfaTravelFeignImpl extends BaseAbstract implements FallbackFactory<SfaTravelFeign> {

    @Override
    public SfaTravelFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaTravelFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaTravelRespVo>> list(SfaTravelReqVo sfaTravelReqVo) {
                doBack();
                PageResult<SfaTravelRespVo> build = PageResult.<SfaTravelRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaTravelRespVo> query(SfaTravelReqVo sfaTravelReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaTravelReqVo sfaTravelReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaTravelReqVo sfaTravelReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaTravelReqVo sfaTravelReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaTravelReqVo sfaTravelReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaTravelReqVo sfaTravelReqVo) {
                return doBack();
            }
        };
    }
}
